/*
 * AfegirAlImmoble.java
 *
 * Created on 29 de mayo de 2008, 16:45
 */

package actions;

import entitats.Llogater;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import locals.Local;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionForward;
/**
 *
 * @author dai
 * @version
 */

public class AfegirAlImmoble extends Action {
    
    DataSource ds = null;
    Connection con = null;
    
    public ActionForward execute(ActionMapping mapping, ActionForm  form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        Local local = (Local) form;
        String tipus;
        
        try {
            
            ds = this.getDataSource(request);
            con = ds.getConnection();
            Statement st = con.createStatement();
            
            //Selecciona el id_local del immoble on s'afegira el nou local
            ResultSet rs = st.executeQuery("SELECT * FROM locals WHERE id_local = "+local.getImmoble());
            rs.next();
            int idAdresa = rs.getInt("id_adresa");
            
            //Selecciona l'adrea del immoble per afegirli la planta i pis del local
            ResultSet rs1 = st.executeQuery("SELECT * from adreses WHERE id_adresa = "+idAdresa);
            rs1.next();
            
            //Introdueix la nova adresa del local
            st.executeUpdate("INSERT INTO adreses (id_zona, adresa) VALUES ("+rs1.getInt("id_zona")+", '"+idAdresa+" "+local.getPlantaPis()+"')");
            rs1.close();
            rs1 = st.executeQuery("SELECT last_insert_id()");
            rs1.next();
            int nouIdAdresa = rs1.getInt(1);
            rs1.close();
            
            //Introdueix el nou local, crea un codi_local temporal que mes tard sera substituit
            PreparedStatement sentencia = con.prepareStatement("INSERT INTO locals(codi_local, id_adresa, tipus, superficie, caracteristiques, restriccions, preu, actiu) VALUES(?,?,?,?,?,?,?,?)");
            sentencia.setString(1, "temporal");
            sentencia.setInt(2, nouIdAdresa);
            sentencia.setString(3, local.getTipus());
            sentencia.setFloat(4, local.getSuperficie());
            sentencia.setString(5, local.getCaracteristiques());
            sentencia.setString(6, local.getRestriccions());
            sentencia.setFloat(7, local.getPreu());
            sentencia.setBoolean(8, false);
            sentencia.executeUpdate();
            
            //Sel.lecciones l'ultim id i a partir d'alli cridem al metode creaCodi de local
            //el qual generara el codi del local, i fa l'update
            rs1 = st.executeQuery("SELECT last_insert_id()");
            rs1.next();
            int idLocalAfegit = rs1.getInt(1);
            String codiLocal = local.creaCodi(idLocalAfegit);
            st.executeUpdate("UPDATE locals set codi_local = '"+codiLocal+"' WHERE id_local = "+idLocalAfegit);
            
            //Depenent del tipus de local(oficina, botiga-magatzem o polivalent) s'insertara en una taula o altra
            if (local.getTipus().equals("oficina")){
                st.executeUpdate("INSERT INTO oficines(id_local) VALUES("+idLocalAfegit+")");
                st.executeUpdate("INSERT INTO immoble_oficina(id_immoble, id_oficina) VALUES("+local.getImmoble()+", "+idLocalAfegit+" )");
            } else if (local.getTipus().equals("botiga_magatzem")){
                st.executeUpdate("INSERT INTO botigues_magatzem(id_local, volum) VALUES("+idLocalAfegit+", "+local.getVolum()+")");
                st.executeUpdate("INSERT INTO immoble_botiga_magatzem(id_immoble, id_botiga_magatzem) VALUES("+local.getImmoble()+", "+idLocalAfegit+")");
            } else if (local.getTipus().equals("polivalent")){
                st.executeUpdate("INSERT INTO polivalents(id_local, caracteristiques_polivalent) VALUES("+idLocalAfegit+", '"+local.getCaracteristiquesPolivalents()+"')");
                st.executeUpdate("INSERT INTO immoble_polivalent(id_immoble, id_polivalent) VALUES("+local.getImmoble()+", "+idLocalAfegit+")");
            }
            st.close();
            local.setError("Local afegit al immoble correctament");
            
        } catch (Exception excepcio){
            local.setError("<font color='red'>Excepcio ocorreguda en acions.AfegirAlImmoble" +
                    "\n"+excepcio.getMessage()+"<font>");
            
        } finally {
            try {
                if (con != null ) {
                    con.close();
                }
            } catch (Exception excepcio){
                local.setError("<font color='red'>Excepcio ocorreguda en acions.AfegirAlImmoble" +
                        "\n"+excepcio.getMessage()+"<font>");
                return mapping.findForward("ok");
            }
        }
        return mapping.findForward("ok");
    }
}
